#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
/*
 *  puzzle.c
 *  
 *  Version: 1.0 Raetselmatrix und Suchwort in Programm fest gesetzt
 *           2.0 Einbau von Auslesen des Raetsels und Suchwortes aus einer Datei
 *               Parameteruebergabe moeglich fuer Dateiname, Suchwort
 *           2.b Nach Feststellen der Richtung wird ueber spezielle Richtungsfunktionen
 *               weitergesucht
 *
*/

struct PuzzleItem {
  int                x,y;         // Position in der Matrix
  char               inhalt;      // Buchstabe
  float              frequenz;    // Haeufigkeit des Auftretens
  struct PuzzleItem  *lo,*o,*ro,*l,*r,*lu,*u,*ru; // Umliegende 8 Nachbarn
} ;

// Index der Buchstaben in der Liste des Alphabets
const char A=0,  B=1,  C=2,  D=3,  E=4;
const char F=5,  G=6,  H=7,  I=8,  J=9;
const char K=10, L=11, M=12, N=13, O=14;
const char P=15, Q=16, R=17, S=18, T=19;
const char U=20, V=21, W=22, X=23, Y=24, Z=25;

// Maximale Dimensionen eines Raetsels
const int MAXX=50, MAXY=50;

void initPuzzle(struct PuzzleItem *item, int x, int y, char buchstabe, float rate) {
  item->x = x;
  item->y = y;
  item->inhalt = buchstabe;
  item->frequenz = rate;
  item->lo = NULL;
  item->o  = NULL;
  item->ro = NULL;
  item->l  = NULL;
  item->r  = NULL;
  item->lu = NULL;
  item->u  = NULL;
  item->ru = NULL;
}

void initPuzzleEnv(struct PuzzleItem *(*matrix)[MAXX], int x, int y) {
  // x und y sind die Dimensionen im Intervall [0,0] bis [x,y]

  int i,j;

  // Eckpunkte
  matrix[0][0]->r  = (struct PuzzleItem *)matrix[0][1];
  matrix[0][0]->ru = (struct PuzzleItem *)matrix[1][1];
  matrix[0][0]->u  = (struct PuzzleItem *)matrix[1][0];

  matrix[0][x]->l  = (struct PuzzleItem *)matrix[0][x-1];
  matrix[0][x]->lu = (struct PuzzleItem *)matrix[1][x-1];
  matrix[0][x]->u  = (struct PuzzleItem *)matrix[1][x];

  matrix[y][0]->o  = (struct PuzzleItem *)matrix[y-1][0];
  matrix[y][0]->ro = (struct PuzzleItem *)matrix[y-1][1];
  matrix[y][0]->r  = (struct PuzzleItem *)matrix[y][1];

  matrix[y][x]->o  = (struct PuzzleItem *)matrix[y-1][x];
  matrix[y][x]->lo = (struct PuzzleItem *)matrix[y-1][x-1];
  matrix[y][x]->l  = (struct PuzzleItem *)matrix[y][x-1];

  // Obere Reihe
  for (i=1; i<x; i++) {
    matrix[0][i]->r  = matrix[0][i+1];
    matrix[0][i]->ru = matrix[1][i+1];
    matrix[0][i]->u  = matrix[1][i];
    matrix[0][i]->lu = matrix[1][i-1];
    matrix[0][i]->l  = matrix[0][i-1];
  }
  // Untere Reihe
  for (i=1; i<x; i++) {
    matrix[y][i]->l  = matrix[y][i-1];
    matrix[y][i]->lo = matrix[y-1][i-1];
    matrix[y][i]->o  = matrix[y-1][i];
    matrix[y][i]->ro = matrix[y-1][i+1];
    matrix[y][i]->r  = matrix[y][i+1];
  }
  // Linke Spalte
  for (j=1; j<y; j++) {
    matrix[j][0]->o  = matrix[j-1][0];
    matrix[j][0]->ro = matrix[j-1][1];
    matrix[j][0]->r  = matrix[j][1];
    matrix[j][0]->ru = matrix[j+1][1];
    matrix[j][0]->u  = matrix[j+1][0];
  }
  // Rechte Spalte
  for (j=1; j<y; j++) {
     matrix[j][x]->u   = matrix[j+1][x];
     matrix[j][x]->lu  = matrix[j+1][x-1];
     matrix[j][x]->l   = matrix[j][x-1];
     matrix[j][x]->lo  = matrix[j-1][x-1];
     matrix[j-1][x]->o = matrix[j-1][x];
  }

  // Der innere Bereich
  for (j=1; j<y; j++) {
    for (i=1; i<x; i++) {
      matrix[j][i]->o  = matrix[j-1][i];
      matrix[j][i]->ro = matrix[j-1][i+1];
      matrix[j][i]->r  = matrix[j][i+1];
      matrix[j][i]->ru = matrix[j+1][i+1];
      matrix[j][i]->u  = matrix[j+1][i];
      matrix[j][i]->lu = matrix[j+1][i-1];
      matrix[j][i]->l  = matrix[j][i-1];
      matrix[j][i]->lo = matrix[j-1][i-1];
    }
  }
}

void sucheWort(struct PuzzleItem *(*matrix)[MAXX], char *suchwort, int xdim, int ydim) {

  int  swlen, swindex;
  char *richtungen[8];
  int  gefunden = 0;
  int  weiter = 0;
  int  startx, starty;
  int  z, j, i;
  struct PuzzleItem *aktuell;

  swlen = strlen(suchwort);
  for (z=0; z<8; z++) {
    richtungen[z] = malloc(5);
    if (richtungen[z]) 
      strcpy(richtungen[z], "no");
  }

  for ( j=0; j<ydim; j++ ) {
    for ( i=0; i<xdim; i++ ) {
      if ( suchwort[0] == matrix[j][i]->inhalt ) {
        aktuell = matrix[j][i];
        swindex = 0;
        weiter = umgebungssuche(aktuell, suchwort, swindex+1, swlen, richtungen);
        for ( z=0; z<weiter; z++ ) {
          if ( (swindex+2) < swlen) {
            if        ( strcmp(richtungen[z],"o") == 0 ) {
              gefunden = richtungssuche_o(aktuell->o, suchwort, swindex+2, swlen, "o");
            } else if ( strcmp(richtungen[z],"ro") == 0 ) {
              gefunden = richtungssuche_ro(aktuell->ro, suchwort, swindex+2, swlen, "ro");
            } else if ( strcmp(richtungen[z],"r") == 0 ) {
              gefunden = richtungssuche_r(aktuell->r, suchwort, swindex+2, swlen, "r");
            } else if ( strcmp(richtungen[z],"ru") == 0 ) {
              gefunden = richtungssuche_ru(aktuell->ru, suchwort, swindex+2, swlen, "ru");
            } else if ( strcmp(richtungen[z],"u") == 0 ) {
              gefunden = richtungssuche_u(aktuell->u, suchwort, swindex+2, swlen, "u");
            } else if ( strcmp(richtungen[z],"lu") == 0 ) {
              gefunden = richtungssuche_lu(aktuell->lu, suchwort, swindex+2, swlen, "lu");
            } else if ( strcmp(richtungen[z],"l") == 0 ) {
              gefunden = richtungssuche_l(aktuell->l, suchwort, swindex+2, swlen, "l");
            } else if ( strcmp(richtungen[z],"lo") == 0 ) {
              gefunden = richtungssuche_lo(aktuell->lo, suchwort, swindex+2, swlen, "lo");
            } else {
              gefunden = 0;
              printf("In Fkt. sucheWort: Fehler ... bei x=%d, y=%d unbekannte %d.te Richtung %s\n",i,j,z,richtungen[z]);
            }
          } else {
            gefunden = 1;
          }
          if ( gefunden == 1 ) {
            printf("Wort \"%s\" gefunden ab Zeile %d und Spalte %d in Richtung %s\n\n",suchwort,j,i,richtungen[z]);
            gefunden = 0;
          }
        } // Ende for z
      }
    } // Ende for i
  } // Ende for j

} // Ende Funktion sucheWort


int umgebungssuche(struct PuzzleItem *item, char *suchwort, int swindex, int swlen, char *richtungen[]) {

  int index = 0;

  if ( (item->o != NULL) && (suchwort[swindex] == item->o->inhalt) ) {
    strcpy(richtungen[index],"o");
    index++;
  }
  if ( (item->ro != NULL) && (suchwort[swindex] == item->ro->inhalt) ) {
    strcpy(richtungen[index],"ro");
    index++;
  }
  if ( (item->r != NULL) && (suchwort[swindex] == item->r->inhalt) ) {
    strcpy(richtungen[index],"r");
    index++;
  }
  if ( (item->ru != NULL) && (suchwort[swindex] == item->ru->inhalt) ) {
    strcpy(richtungen[index],"ru");
    index++;
  }
  if ( (item->u != NULL) && (suchwort[swindex] == item->u->inhalt) ) {
    strcpy(richtungen[index],"u");
    index++;
  }
  if ( (item->lu != NULL) && (suchwort[swindex] == item->lu->inhalt) ) {
    strcpy(richtungen[index],"lu");
    index++;
  }
  if ( (item->l != NULL) && (suchwort[swindex] == item->l->inhalt) ) {
    strcpy(richtungen[index],"l");
    index++;
  }
  if ( (item->lo != NULL) && (suchwort[swindex] == item->lo->inhalt) ) {
    strcpy(richtungen[index],"lo");
    index++;
  }
  return index;

} // Ende Funktion umgebungssuche


int richtungssuche_o(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->o == NULL )  { return 0; }
  if ( item->o->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_o(item->o, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_o

int richtungssuche_ro(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->ro == NULL ) { return 0; }
  if ( item->ro->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_ro(item->ro, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_ro

int richtungssuche_r(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->r == NULL ) { return 0; }
  if ( item->r->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_r(item->r, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_r

int richtungssuche_ru(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->ru == NULL ) { return 0; }
  if ( item->ru->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_ru(item->ru, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_ru

int richtungssuche_u(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->u == NULL ) { return 0; }
  if ( item->u->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_u(item->u, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_u

int richtungssuche_lu(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->lu == NULL ) { return 0; }
  if ( item->lu->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_lu(item->lu, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_lu

int richtungssuche_l(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->l == NULL ) { return 0; }
  if ( item->l->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_l(item->l, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_l

int richtungssuche_lo(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->lo == NULL ) { return 0; }
  if ( item->lo->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_lo(item->lo, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_lo



void showMatrix(char *ptr_matrix, int x, int y) {

  int j,i;

  printf("   |");
  for (i=0; i<x; i++) {
      printf("%2d",i);
  }
  printf("\n");
  printf("---|");
  for (i=0; i<x; i++) {
      printf("--");
  }
  printf("\n");

  for ( j=0; j<y; j++ ) {
    printf("%2d |",j);
    for ( i=0; i<x; i++ ) {
      printf(" %c",*(ptr_matrix+j*x+i));
    }
    printf("\n");
  }

} // Ende Funktion showMatrix


char *readMatrix(int *x, int *y, char *inputfile) {

  char *ptr_matrix;
  int j,i;
  int ret;
  FILE *fp;
  
  ptr_matrix = NULL;
  fp = fopen(inputfile, "r");
  if ( fp == NULL ) {
    printf("In readMatrix: Datei %s konnte nicht geoeffnet werden.\n",inputfile);
  } else {
    ret = fscanf(fp,"%d %d\n", x, y);
    if ( ret !=2 ) {
      printf("In readMatrix: Nur %d Wert(e) fuer 2 Dimensionen gelesen\n",ret);
      return(NULL);
    }
    if ( *x > MAXX || *y > MAXY ) {
      printf("In readMatrix: Dimensionen (x=%d,y=%d) groesser als zulaessig: (MAXX=%d,MAXY=%d)\n",*x,*y,MAXX,MAXY);
      return(NULL);
    }
    ptr_matrix = (char *)malloc(sizeof(char)*(*x)*(*y));

    for (j=0; j<*y; j++) {
      for (i=0; i<*x; i++) {
        ret = fscanf(fp,"%c ",(ptr_matrix+j*(*x)+i));
        if ( ret !=1 ) {
          printf("In readMatrix: ret=%d Unerwartetes Ende in Datei ab Spalte=%d(%d), Zeile=%d(%d)\n",ret,i+1,*x,j+1,*y);
          return(NULL);
        }
      }
    }
    fclose(fp);
  }

  return(ptr_matrix);

} // Ende Funktion readMatrix


/**********************************************************/
/*** MAIN *************************************************/
/**********************************************************/
int main(int argc,char **argv)
{

  struct PuzzleItem *puzzle[MAXY][MAXX]; 
  int px=0, py=0;     // Dimensionen des aktuellen Puzzles
  int i, j;           // Indizes 
  char *rmatrix;
  char raetseldatei[] = "m1.mtx";
  char suchwort[] = "drei";
  FILE *fp;

  if ((argc == 2) || (argc > 3)) {
    (void) fprintf(stdout,"Usage: %s [Name der Datei mit dem Raetsel] [Suchwort]\n",argv[0]);
    (void) fprintf(stdout,"       Default des Dateinamens ist %s \n",raetseldatei);
    (void) fprintf(stdout,"       Default des Suchwortes ist %s \n",suchwort);
    exit(0);
  } else if (argc == 3) {
    strcpy(raetseldatei,argv[1]);
    strcpy(suchwort,argv[2]);
  }

  printf("\nSuche Wort \"%s\" in Raetsel aus Datei %s \n\n",suchwort,raetseldatei);

  // 1. Lese die Raetselmatrix aus Datei ein
  rmatrix = readMatrix(&px, &py, raetseldatei);
  if ( rmatrix == NULL ) {
    (void) fprintf(stdout,"Ende: Fehler beim Einlesen der Datei %s\n",raetseldatei);
    exit(0);
  }

  // 2. Gebe die Raetselmatrix aus
  showMatrix(rmatrix, px, py);

  // 1. Erzeuge die Strukturmatrix zum Buchstaben-Puzzle 
  for (j=0; j<py; j++) {
    for (i=0; i<px; i++) {
      puzzle[j][i] = (struct PuzzleItem *)malloc(sizeof(struct PuzzleItem));
      initPuzzle(puzzle[j][i], j, i, *(rmatrix+j*(px)+i), 0.0);
    }
  }

  // 3. Ermittle die Umgebung eines Punktes
  initPuzzleEnv(puzzle, px-1, py-1);

  // 4. Suche das Wort
  sucheWort(puzzle, suchwort, px, py);


  return(0);
}
