#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <gtk/gtk.h>

/*
 *  pgui.c
 *  
 *  Version: 1.0 Ist das Suchwort gesetzt, wird nach Uebereinstimmung des Anfangs-
 *               buchstabens in die umgebenden Richtungen ueber spezielle Richtungs-
 *               funktionen weitergesucht.
 *
*/

// Maximale Dimensionen eines Raetsels 
const int MAXX=50, MAXY=50;

char *global_rmatrix;
int  global_px, global_py;

struct PuzzleItem {
  int                x,y;         // Position in der Matrix
  char               inhalt;      // Buchstabe
  float              frequenz;    // Haeufigkeit des Auftretens
  struct PuzzleItem  *lo,*o,*ro,*l,*r,*lu,*u,*ru; // Umliegende 8 Nachbarn
} ;

void initPuzzle(struct PuzzleItem *item, int x, int y, char buchstabe, float rate) {
  item->x = x;
  item->y = y;
  item->inhalt = buchstabe;
  item->frequenz = rate;
  item->lo = NULL;
  item->o  = NULL;
  item->ro = NULL;
  item->l  = NULL;
  item->r  = NULL;
  item->lu = NULL;
  item->u  = NULL;
  item->ru = NULL;
}

void initPuzzleEnv(struct PuzzleItem *(*matrix)[MAXX], int x, int y) {
  // x und y sind die Dimensionen im Intervall [0,0] bis [x,y]

  int i,j;

  // Eckpunkte
  matrix[0][0]->r  = (struct PuzzleItem *)matrix[0][1];
  matrix[0][0]->ru = (struct PuzzleItem *)matrix[1][1];
  matrix[0][0]->u  = (struct PuzzleItem *)matrix[1][0];

  matrix[0][x]->l  = (struct PuzzleItem *)matrix[0][x-1];
  matrix[0][x]->lu = (struct PuzzleItem *)matrix[1][x-1];
  matrix[0][x]->u  = (struct PuzzleItem *)matrix[1][x];

  matrix[y][0]->o  = (struct PuzzleItem *)matrix[y-1][0];
  matrix[y][0]->ro = (struct PuzzleItem *)matrix[y-1][1];
  matrix[y][0]->r  = (struct PuzzleItem *)matrix[y][1];

  matrix[y][x]->o  = (struct PuzzleItem *)matrix[y-1][x];
  matrix[y][x]->lo = (struct PuzzleItem *)matrix[y-1][x-1];
  matrix[y][x]->l  = (struct PuzzleItem *)matrix[y][x-1];

  // Obere Reihe
  for (i=1; i<x; i++) {
    matrix[0][i]->r  = matrix[0][i+1];
    matrix[0][i]->ru = matrix[1][i+1];
    matrix[0][i]->u  = matrix[1][i];
    matrix[0][i]->lu = matrix[1][i-1];
    matrix[0][i]->l  = matrix[0][i-1];
  }
  // Untere Reihe
  for (i=1; i<x; i++) {
    matrix[y][i]->l  = matrix[y][i-1];
    matrix[y][i]->lo = matrix[y-1][i-1];
    matrix[y][i]->o  = matrix[y-1][i];
    matrix[y][i]->ro = matrix[y-1][i+1];
    matrix[y][i]->r  = matrix[y][i+1];
  }
  // Linke Spalte
  for (j=1; j<y; j++) {
    matrix[j][0]->o  = matrix[j-1][0];
    matrix[j][0]->ro = matrix[j-1][1];
    matrix[j][0]->r  = matrix[j][1];
    matrix[j][0]->ru = matrix[j+1][1];
    matrix[j][0]->u  = matrix[j+1][0];
  }
  // Rechte Spalte
  for (j=1; j<y; j++) {
     matrix[j][x]->u   = matrix[j+1][x];
     matrix[j][x]->lu  = matrix[j+1][x-1];
     matrix[j][x]->l   = matrix[j][x-1];
     matrix[j][x]->lo  = matrix[j-1][x-1];
     matrix[j-1][x]->o = matrix[j-1][x];
  }

  // Der innere Bereich
  for (j=1; j<y; j++) {
    for (i=1; i<x; i++) {
      matrix[j][i]->o  = matrix[j-1][i];
      matrix[j][i]->ro = matrix[j-1][i+1];
      matrix[j][i]->r  = matrix[j][i+1];
      matrix[j][i]->ru = matrix[j+1][i+1];
      matrix[j][i]->u  = matrix[j+1][i];
      matrix[j][i]->lu = matrix[j+1][i-1];
      matrix[j][i]->l  = matrix[j][i-1];
      matrix[j][i]->lo = matrix[j-1][i-1];
    }
  }
}


void sucheWort(struct PuzzleItem *(*matrix)[MAXX], const gchar *suchwort, int xdim, int ydim, char ergebnis[1024]) {

  int  swlen, swindex;
  char *richtungen[8];
  int  gefunden = 0;
  int  weiter = 0;
  int  z, j, i;
  struct PuzzleItem *aktuell;
  char zwspeicher[1024];

  swlen = strlen(suchwort);
  for (z=0; z<8; z++) {
    richtungen[z] = malloc(10);
    if (richtungen[z])
      strcpy(richtungen[z], "no");
  }

  for ( j=0; j<ydim; j++ ) {
    for ( i=0; i<xdim; i++ ) {
      if ( suchwort[0] == matrix[j][i]->inhalt ) {
        aktuell = matrix[j][i];
        swindex = 0;
        weiter = umgebungssuche(aktuell, suchwort, swindex+1, swlen, richtungen);
        for ( z=0; z<weiter; z++ ) {
          if ( (swindex+2) < swlen) {
            if        ( strcmp(richtungen[z],"o") == 0 ) {
              gefunden = richtungssuche_o(aktuell->o, suchwort, swindex+2, swlen, "o");
            } else if ( strcmp(richtungen[z],"ro") == 0 ) {
              gefunden = richtungssuche_ro(aktuell->ro, suchwort, swindex+2, swlen, "ro");
            } else if ( strcmp(richtungen[z],"r") == 0 ) {
              gefunden = richtungssuche_r(aktuell->r, suchwort, swindex+2, swlen, "r");
            } else if ( strcmp(richtungen[z],"ru") == 0 ) {
              gefunden = richtungssuche_ru(aktuell->ru, suchwort, swindex+2, swlen, "ru");
            } else if ( strcmp(richtungen[z],"u") == 0 ) {
              gefunden = richtungssuche_u(aktuell->u, suchwort, swindex+2, swlen, "u");
            } else if ( strcmp(richtungen[z],"lu") == 0 ) {
              gefunden = richtungssuche_lu(aktuell->lu, suchwort, swindex+2, swlen, "lu");
            } else if ( strcmp(richtungen[z],"l") == 0 ) {
              gefunden = richtungssuche_l(aktuell->l, suchwort, swindex+2, swlen, "l");
            } else if ( strcmp(richtungen[z],"lo") == 0 ) {
              gefunden = richtungssuche_lo(aktuell->lo, suchwort, swindex+2, swlen, "lo");
            } else {
              gefunden = 0;
              printf("In Fkt. sucheWort: Fehler ... bei x=%d, y=%d unbekannte %d.te Richtung %s\n",i,j,z,richtungen[z]);
              sprintf(zwspeicher,"In Fkt. sucheWort: Fehler bei x=%d, y=%d unbekannte %d.te Richtung %s\n",i,j,z,richtungen[z]);
              strcat(ergebnis,zwspeicher);
            }
          } else {
            gefunden = 1;
          }
          if ( gefunden == 1 ) {
            printf("Wort \"%s\" gefunden ab Zeile %d und Spalte %d in Richtung %s\n",suchwort,j,i,richtungen[z]);
            sprintf(zwspeicher,"Wort \"%s\" gefunden ab Zeile %d und Spalte %d in Richtung %s\n",suchwort,j,i,richtungen[z]);
            strcat(ergebnis,zwspeicher);
            gefunden = 0;
          }
        } // Ende for z
      } // Ende if suchwort == matrix
    } // Ende for i
  } // Ende for j

} // Ende Funktion sucheWort


int umgebungssuche(struct PuzzleItem *item, char *suchwort, int swindex, int swlen, char *richtungen[]) {

  int index = 0;

  if ( (item->o != NULL) && (suchwort[swindex] == item->o->inhalt) ) {
    strcpy(richtungen[index],"o");
    index++;
  }
  if ( (item->ro != NULL) && (suchwort[swindex] == item->ro->inhalt) ) {
    strcpy(richtungen[index],"ro");
    index++;
  }
  if ( (item->r != NULL) && (suchwort[swindex] == item->r->inhalt) ) {
    strcpy(richtungen[index],"r");
    index++;
  }
  if ( (item->ru != NULL) && (suchwort[swindex] == item->ru->inhalt) ) {
    strcpy(richtungen[index],"ru");
    index++;
  }
  if ( (item->u != NULL) && (suchwort[swindex] == item->u->inhalt) ) {
    strcpy(richtungen[index],"u");
    index++;
  }
  if ( (item->lu != NULL) && (suchwort[swindex] == item->lu->inhalt) ) {
    strcpy(richtungen[index],"lu");
    index++;
  }
  if ( (item->l != NULL) && (suchwort[swindex] == item->l->inhalt) ) {
    strcpy(richtungen[index],"l");
    index++;
  }
  if ( (item->lo != NULL) && (suchwort[swindex] == item->lo->inhalt) ) {
    strcpy(richtungen[index],"lo");
    index++;
  }
  return index;

} // Ende Funktion umgebungssuche


int richtungssuche_o(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->o == NULL )  { return 0; }
  if ( item->o->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_o(item->o, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_o

int richtungssuche_ro(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->ro == NULL ) { return 0; }
  if ( item->ro->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_ro(item->ro, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_ro

int richtungssuche_r(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->r == NULL )  { return 0; } 
  if ( item->r->inhalt == suchwort[swindex] ) 
      gefunden = richtungssuche_r(item->r, suchwort, swindex+1, swlen);
  else  
     return 0; 
  return gefunden;
} // Ende Funktion richtungssuche_r

int richtungssuche_ru(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->ru == NULL ) { return 0; }
  if ( item->ru->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_ru(item->ru, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_ru

int richtungssuche_u(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->u == NULL )  { return 0; }
  if ( item->u->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_u(item->u, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_u

int richtungssuche_lu(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->lu == NULL ) { return 0; }
  if ( item->lu->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_lu(item->lu, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_lu

int richtungssuche_l(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->l == NULL )  { return 0; }
  if ( item->l->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_l(item->l, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_l

int richtungssuche_lo(struct PuzzleItem *item, char *suchwort, int swindex, int swlen) {
  int gefunden;
  if ( swindex >= swlen ) { return 1; }
  if ( item->lo == NULL ) { return 0; }
  if ( item->lo->inhalt == suchwort[swindex] )
      gefunden = richtungssuche_lo(item->lo, suchwort, swindex+1, swlen);
  else
      return 0;
  return gefunden;
} // Ende Funktion richtungssuche_lo


void showMatrix(GtkTextBuffer *buffer, char *ptr_matrix, int x, int y) {

  int j,i;
  char *matrix;
  char *zwspeicher;

  GtkTextIter anfang, ende;

  // 2*x+4+1 + 2*x+4+1 + y*(4+x*2+1)
  // = (y+2)*(2x+5) = 2xy+5y+4x+10
  matrix = malloc(2*x*y+5*y+4*x+100);
  zwspeicher = malloc(2*x*y+5*y+4*x+100);

  strcpy(matrix,"   |");
  for (i=0; i<x; i++) {
      sprintf(zwspeicher,"%2d",i);
      strcat(matrix,zwspeicher);
  }
  strcat(matrix,"\n---|");
  for (i=0; i<x; i++) {
      sprintf(zwspeicher,"--");
      strcat(matrix,zwspeicher);
  }
  sprintf(zwspeicher,"\n");
  strcat(matrix,zwspeicher);

  for ( j=0; j<y; j++ ) {
    sprintf(zwspeicher,"%2d |",j);
    strcat(matrix,zwspeicher);
    for ( i=0; i<x; i++ ) {
      sprintf(zwspeicher," %c",*(ptr_matrix+j*x+i));
      strcat(matrix,zwspeicher);
    }
    sprintf(zwspeicher,"\n");
    strcat(matrix,zwspeicher);
  }

  /* Kopiere den Text in den Buffer */
  gtk_text_buffer_set_text ( buffer, matrix, -1 );
  /* Formatiere den Buffer */
  gtk_text_buffer_get_bounds (buffer, &anfang, &ende);
  gtk_text_buffer_apply_tag_by_name(buffer,"font",&anfang, &ende);


} // Ende Funktion showMatrix


char *readMatrix(int *x, int *y, char *inputfile) {

  char *ptr_matrix;
  int j,i;
  int ret;
  FILE *fp;

  ptr_matrix = NULL;
  fp = fopen(inputfile, "r");
  if ( fp == NULL ) {
    printf("In readMatrix: Datei %s konnte nicht geoeffnet werden.\n",inputfile);
  } else {
    ret = fscanf(fp,"%d %d\n", x, y);
    if ( ret !=2 ) {
      printf("In readMatrix: Nur %d Wert(e) fuer 2 Dimensionen gelesen\n",ret);
      return(NULL);
    }
    if ( *x > MAXX || *y > MAXY ) {
      printf("In readMatrix: Dimensionen (x=%d,y=%d) groesser als zulaessig: (MAXX=%d,MAXY=%d)\n",*x,*y,MAXX,MAXY);
      return(NULL);
    }
    ptr_matrix = (char *)malloc(sizeof(char)*(*x)*(*y));

    for (j=0; j<*y; j++) {
      for (i=0; i<*x; i++) {
        ret = fscanf(fp,"%c ",(ptr_matrix+j*(*x)+i));
        if ( ret !=1 ) {
          printf("In readMatrix: ret=%d Unerwartetes Ende in Datei ab Spalte=%d(%d), Zeile=%d(%d)\n",ret,i+1,*x,j+1,*y);
          return(NULL);
        }
      }
    }
    fclose(fp);
  }

  return(ptr_matrix);

} // Ende Funktion readMatrix



static gint delete_Event(GtkWidget * widget, GdkEvent event, gpointer daten){
  g_print ("Das Fenster wird zerstoert!\n");
  /* Nur mit FALSE wird die Anwendung wirklich beendet */
  return FALSE;
}
static void end (GtkWidget * widget, gpointer daten) {
  g_print ("Und tschuess!\n");
  /* Die Verarbeitungsschleife beenden */
  gtk_main_quit ();
}

static void suchwort_enter_callback (GtkWidget * widget, gchar *daten) {
  const gchar *suchwort;
  struct PuzzleItem *puzzle[MAXY][MAXX];
  int   i,j;
  char  fund[1024] = "";
  GtkWindow *toplevel = gtk_widget_get_toplevel(widget);

  suchwort = gtk_entry_get_text (GTK_ENTRY(daten));
  g_print ("Suchwort ist %s\n", suchwort);

  if ( global_rmatrix == NULL ) {
    show_warning(toplevel, "Zuerst muss eine Buchstabenmatrix geladen werden.");
    return;
  }
  if ( strlen(suchwort) <= 1 ) {
    show_warning(toplevel, "Wort muss mindestens zwei Buchstaben besitzen.");
    return;
  }

  // 3. Erzeuge die Strukturmatrix zum Buchstaben-Puzzle 
  g_print ("Setze Strukturmatrix\n");
  for (j=0; j<global_py; j++) {
    for (i=0; i<global_px; i++) {
      puzzle[j][i] = (struct PuzzleItem *)malloc(sizeof(struct PuzzleItem));
      initPuzzle(puzzle[j][i], j, i, *(global_rmatrix+j*(global_px)+i), 0.0);
    }
  }

  // 3. Ermittle die Umgebung eines Punktes
  initPuzzleEnv(puzzle, global_px-1, global_py-1);

  // 4. Suche das Wort
  sucheWort(puzzle, suchwort, global_px, global_py, fund);

  // 5. Gebe das Ergebnis bekannt
  show_info(toplevel, fund);
  
}


static void open_file (GtkWidget *widget, gpointer *parray) {

  GtkWidget *dialog;

  int px=0, py=0;     // Dimensionen des aktuellen Puzzles
  char *filename;
  gchar fehlertext[100];

  GtkWindow *window;
  GtkTextBuffer *buffer;

  window = parray[0];
  buffer = parray[1];

  dialog = gtk_file_chooser_dialog_new ("Open File",
  				      window,
  				      GTK_FILE_CHOOSER_ACTION_OPEN,
     				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
     				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
     				      NULL);
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
  
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
    g_print ("Oeffne File %s\n", filename);

  }
  gtk_widget_destroy (dialog);

  // 1. Lese die Raetselmatrix aus Datei ein
  g_print ("Lese ein\n");
  global_rmatrix = readMatrix(&px, &py, filename);
  global_px = px;
  global_py = py;

  if ( global_rmatrix == NULL ) {
    (void) fprintf(stdout,"Ende: Fehler beim Einlesen der Datei %s\n",filename);
    strcpy(fehlertext,"Fehler beim Einlesen der Datei");
    show_error(window, fehlertext);
  } else {
    g_print ("Gebe aus in Textfeld\n");
    // 2. Gebe die Raetselmatrix aus
    showMatrix(buffer, global_rmatrix, px, py);
  }
} // Ende open_file


void show_info(gpointer window, gchar *info) {
    
  GtkWidget *dialog;
  dialog = gtk_message_dialog_new(GTK_WINDOW(window),
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_INFO,
            GTK_BUTTONS_OK,
            info );
  gtk_window_set_title(GTK_WINDOW(dialog), "Information");
  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
}

void show_warning(gpointer window, gchar *warnung) {
    
  GtkWidget *dialog;
  dialog = gtk_message_dialog_new(GTK_WINDOW(window),
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_WARNING,
            GTK_BUTTONS_OK,
            warnung);
  gtk_window_set_title(GTK_WINDOW(dialog), "Warnung");
  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
}

void show_error(gpointer window, gchar *fehler) {
    
  GtkWidget *dialog;
  dialog = gtk_message_dialog_new(GTK_WINDOW(window),
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_ERROR,
            GTK_BUTTONS_OK,
            fehler);
  gtk_window_set_title(GTK_WINDOW(dialog), "Fehler");
  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
}


/*******************************************************/
/*** M A I N *******************************************/
/*******************************************************/

int main( int   argc,
          char *argv[] )
{
  GtkWindow *win;
  GdkPixbuf *pic;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *textbox;
  GtkWidget *textfeld;
  GtkWidget *label;
  GtkWidget *button;
  GtkTextBuffer *buffer;

  GtkTextIter anfang, ende;
  
  guint16 textlen;
  gchar matrix[256];
  gpointer parray[2];


  printf("Beginn von main in pgui.c\n");

  /* 1. Die Umgebung initialisieren */
  gtk_init(&argc, &argv);
  /* 2. Die Widgets erzeugen */
  /* Eine Grafik in einen Pixbuf laden */
  pic = gdk_pixbuf_new_from_file("icon/kk.gif", NULL);
  /* 2a. Fenster mit den folgenden Eigenschaften ... anlegen */
  win = g_object_new( GTK_TYPE_WINDOW,
                       "title", "Die Suchmatrix",
                       "resizable", TRUE,
                       "window-position", GTK_WIN_POS_CENTER,
                       "border-width", 5,
                       "icon", pic,
                       NULL );
  /* 3. Signalhandler (Callback-Funktion) einrichten */
  g_signal_connect ( win, "delete-event",
                     G_CALLBACK (delete_Event), NULL);
  g_signal_connect ( win, "destroy",
                     G_CALLBACK (end), NULL);
  /* 4. Hier ist noch nichts */
  vbox = gtk_vbox_new (FALSE, 2);
  gtk_container_add (GTK_CONTAINER (win), vbox);

  /* Create a textbox zur Darstellung der Puzzle-Matrix */
  buffer = gtk_text_buffer_new (NULL);
  textbox = gtk_text_view_new_with_buffer (buffer);
  gtk_text_view_set_editable(GTK_TEXT_VIEW(textbox), FALSE);
  gtk_text_view_set_left_margin(GTK_TEXT_VIEW(textbox), 5);
  gtk_text_view_set_right_margin(GTK_TEXT_VIEW(textbox), 5);

  /* Kopiere den Text in den Buffer */
  strcpy(matrix,"Zur Zeit ist keine Suchmatrix geladen.\n");
  gtk_text_buffer_set_text ( buffer, matrix, -1 );

  /* Formatiere den Buffer */
  gtk_text_buffer_get_bounds (buffer, &anfang, &ende);
  gtk_text_buffer_create_tag(buffer,"font","font","Courier New 10");
  gtk_text_buffer_apply_tag_by_name(buffer,"font",&anfang, &ende);

  gtk_box_pack_start (GTK_BOX (vbox), textbox, FALSE, FALSE, 0);

  /* Create a horizontal box */
  hbox = gtk_hbox_new (FALSE, 10); /* homogeneous, spacing */

  /* Create an open button. */
  button = gtk_button_new_with_label ("Open");
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0); 
  parray[0] = win;
  parray[1] = buffer;
  g_signal_connect (G_OBJECT (button), "clicked",
                    G_CALLBACK (open_file),
                    parray);

  /* Create a label. */
  label = gtk_label_new ("Suchwort: ");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.6);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  /* Create a text entry field. */
  textlen = 20;
  textfeld = gtk_entry_new();
  gtk_entry_set_max_length(GTK_ENTRY(textfeld), textlen );
  g_signal_connect(GTK_OBJECT(textfeld), "activate",
                     GTK_SIGNAL_FUNC(suchwort_enter_callback),
                     textfeld);
  gtk_box_pack_start (GTK_BOX (hbox), textfeld, FALSE, FALSE, 0);

  /* Create a quit button. */
  button = gtk_button_new_with_label ("Quit");
  gtk_box_pack_start (GTK_BOX (hbox), button, 0, 0, 0);
  g_signal_connect (G_OBJECT (button), "clicked",
                    G_CALLBACK (end),
                    win);

  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  /* 5. (Widgets-)Fenster anzeigen */
  gtk_widget_show_all(GTK_WIDGET (win));

  /* 6. Hauptschleife von gtk-Verarbeitungsschleife */
  gtk_main();
  g_print("Die GTK-Hauptschleife wurde beendet\n");

  return 0;
}
